-------------
-- Switches
-------------
exportFiles = false
makeList = true

--------------------------------------------------------------------------
-- Define some variables for loading bip files onto an avatar
--------------------------------------------------------------------------
listStart = 1 -- How far into the list is this set of animations? Used to generate numbering for animations
animFramerate=30

prefix = "CC2_mHigh_" -- Gender and LOD. it seems redundant to include gender when it's already, but this is actually just saying the skeleton name the file goes with
bipAnimFiles = getfiles "X:\\temp output\\anim in\\*.bip" -- input file directory and *.bip
cal3dSkel = "X:\\temp output\\skel\CC2_mHigh_Skeleton.CSF" -- skeleton used

outputFolder = "X:\\temp output\\anim out\\" -- output folder
outputListName = "femHigh_AnimListA1-1.5.txt" -- Name of file to output the animation list to

maxSkel = $Bip01 -- Max skeleton root

maxSkelCtrl = maxSkel.controller -- Leave this value alone. Gets controller of the root. 

bonesSetName = "bones" -- name of selection set with the bones
bonesList = #() -- Leave this value alone. Array for bones list. 

theStartFrame = 0 -- Leave this value alone. Temp start frame value
theEndFrame = 1 -- Leave this value alone. Temp end frame value

------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------------------------------------------

---------------------------------
-- Optimization improvements
---------------------------------
st = timestamp() -- Get initial timestamp
-- disable redraw for performance reasons
--with redraw off 

-------------------------------------------------------
-- Determine skeleton ID and load bone list array
-------------------------------------------------------
boneSetNum = "none known"
notFound = true

--Detect selection set named "bones"
for x=1 to selectionSets.count while notfound do
	(
	tempName = selectionSets[x].name	
	if (tempName as string) == bonesSetName then 
		(
		print ("yes: " + x as string)
		print setName
		boneSetNum = x
		notfound = false
		)
	else print "no set named '"+ bonesSetName + "' found yet"
	)
bonesList = for obj in selectionSets[boneSetNum] collect obj
--print bonesList

--------------------------------------------
-- Loop through the bip animation files
--------------------------------------------
for f in bipAnimFiles while exportFiles do 
	(
	-----------------------
	-- load animation "f"
	-----------------------
	biped.loadBipFile maxSkelCtrl f
	
	-- Update start and end frames
	--theStartFrame = (substring (animationRange.start as string) 1 ((animationRange.start as string).count as Integer - 1)) as Integer
	theEndFrame = (substring (animationRange.end as string) 1 ((animationRange.end as string).count as Integer - 1)) as Integer
	------------------------------
	-- Export Current animtion
	------------------------------
	cal3dAnim = (outputFolder + prefix + (getFilenameFile f)+".CAF") -- determine output file name
	
	--ExportCalAnim <string:filepath> <string:Skeleton filepath> <node_array:Bones list> <int:start frame> <int:end frame> <int:frame offset> <int:framerate>
	res = exportcalanim cal3dAnim cal3dSkel boneslist theStartFrame theEndFrame 1 animFramerate transform:false
	case res of
		(
			(-2) : print "An Exception occured in the ExportAnimation plugin function"
			(-1) : print "ExportAnimation didn't work"
			0 : print "everything went right"
			1 : print "the first parameter : <string:filepath> is a null string."
			2 : print "the second parameter : <string:Skeleton filepath> is a null string."
			3 : print ("The skeleton file is not a valid file : \n" + skeletonFile)
			4 : print ("The Names Selection Set that lists the bones is empty. "+ (cal3dAnim as string))
			5 : print ("The Start frame is negative. Start: "+ (animationRange.start as string) + ". " + (cal3dAnim as string))
			6 : print ("The End frame is negative. End: "+ (animationRange.end as string) + ". " + (cal3dAnim as string))
			7 : print ("The Start frame is greater than the End frame. Range:"+ (animationRange as string) + ". " + (cal3dAnim as string))
			8 : print ("The offset (sample rate) is negative. "+ (cal3dAnim as string))
			9 : print ("The framerate is negative. "+ (cal3dAnim as string))
			10 : print ("The Names Selection Set that lists the bones contains invalid nodes. "+ (cal3dAnim as string))
		)
	-----------------------
	-- clear animation
	-----------------------
	biped.clearAllAnimation maxSkelCtrl
	animationRange = interval 0 1
	)
	
---------------------------------------
-- write to list of animation names
---------------------------------------
out_file = createfile (outputFolder + outputListName) -- output file
for f in bipAnimFiles while makeList do 
	(
    cal3dAnimName = (prefix + (getFilenameFile f)+".CAF") -- determine output file name
	--Write to file
	if listStart == 1 then
		(
		format "################# Animations #################" to:out_file
		format "\n" to:out_file
		)
			
	-- add four extra lines every 25 animations, but never on the first line
	if (mod (listStart-1) 25) == 0.0 and listStart != 1 then
		(
		format "\n" to:out_file
		format "\n" to:out_file
		format "\n" to:out_file
		)
	-- add extra line after every five animations and add anim #
	if (mod (listStart-1) 5) == 0.0 or listStart == 1 then
		(
		format "\n" to:out_file
		format "#%\n" listStart to:out_file
		)
			
	format "animation = %\n" cal3dAnimName to:out_file
	print ("Anim #" + (listStart as string) + ": " + (getFilenameFile f as string))
		
	listStart = listStart + 1 -- increment number
	)
------------------------------
-- More optimization stuff
------------------------------
-- Get script time	
et = timestamp() --stop the time
print ("Script Time: " + (et-st) as string + "ms")
